/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.ironchests.common.network.forge;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import tech.thatgravyboat.ironchests.common.network.handlers.IPacket;
import tech.thatgravyboat.ironchests.common.network.handlers.IPacketHandler;

public class NetPacketHandlerImpl {
    private static int id = 0;
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("ironchests", "main_channel"), () -> "1", "1"::equals, "1"::equals);

    public static <T extends IPacket<T>> void sendToAllLoaded(T packet, Level level, BlockPos pos) {
        INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(pos)), packet);
    }

    public static <T> void registerServerToClientPacket(ResourceLocation location, IPacketHandler<T> handler, Class<T> tClass) {
        NetPacketHandlerImpl.clientOnlyRegister(handler, tClass);
    }

    private static <T> void clientOnlyRegister(IPacketHandler<T> handler, Class<T> tClass) {
        ++id;
        INSTANCE.registerMessage(id, tClass, handler::encode, handler::decode, (t, context) -> {
            Player sender;
            Object object = sender = ((NetworkEvent.Context)context.get()).getDirection().getReceptionSide().equals((Object)LogicalSide.CLIENT) ? NetPacketHandlerImpl.getPlayer() : null;
            if (sender != null) {
                ((NetworkEvent.Context)context.get()).enqueueWork(() -> handler.handle(t).accept(sender));
            }
            ((NetworkEvent.Context)context.get()).setPacketHandled(true);
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Player getPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }
}

